/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.command;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Typeface;
import androidx.annotation.Nullable;
import com.gainscha.jzint.JzInt;
import com.gainscha.jzint.JzintSymbol;
import com.gprinter.bean.BarCodeType;
import com.gprinter.command.EscCommand;
import com.gprinter.utils.BitmapUtils;
import java.util.List;

public class EscForDotCommand
extends EscCommand {
    public static final int BITMAP_MODE_8_BITS = 0;
    public static final int BITMAP_MODE_8_BITS_DUAL = 1;
    public static final int BITMAP_MODE_24_BITS = 32;
    public static final int BITMAP_MODE_24_BITS_DUAL = 33;
    private static final byte ESC = 27;

    public void addBarcode(BarCodeType barcodeType, int width, int height, boolean humanReadText, int humanReadTextSize, String content) {
        JzintSymbol symbol = new JzintSymbol();
        symbol.width = width;
        symbol.height = height;
        symbol.show_hrt = humanReadText ? 1 : 0;
        symbol.fontsize = humanReadTextSize;
        symbol.input_mode = 0;
        switch (barcodeType) {
            case BARCODE_UPC_A: {
                symbol.symbology = 34;
                break;
            }
            case BARCODE_UPC_E: {
                symbol.symbology = 37;
                break;
            }
            case BARCODE_EAN8: 
            case BARCODE_EAN13: {
                symbol.symbology = 13;
                break;
            }
            case BARCODE_CODE39: {
                symbol.symbology = 8;
                break;
            }
            case BARCODE_ITF: {
                symbol.symbology = 89;
                break;
            }
            case BARCODE_CODABAR: {
                symbol.symbology = 18;
                break;
            }
            case BARCODE_CODE93: {
                symbol.symbology = 25;
                break;
            }
            default: {
                symbol.symbology = 20;
            }
        }
        Bitmap bitmap = JzInt.create((JzintSymbol)symbol, (String)content, (Typeface)Typeface.DEFAULT, (boolean)true, (boolean)true, (int)(humanReadText ? 2 : 0), (int)1);
        Bitmap dst = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(dst);
        canvas.drawColor(-1);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        this.addBitmap(dst, false, 0);
    }

    public void addQrcode(int width, int height, String content) {
        JzintSymbol symbol = new JzintSymbol();
        symbol.width = width;
        symbol.height = height;
        symbol.scale = (float)width / 42.0f + 2.0f;
        symbol.input_mode = 0;
        symbol.symbology = 58;
        Bitmap bitmap = JzInt.create((JzintSymbol)symbol, (String)content, (Typeface)Typeface.DEFAULT, (boolean)true, (boolean)true, (int)0, (int)1);
        Bitmap dst = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(dst);
        canvas.drawColor(-1);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        this.addBitmap(dst, false, 0);
    }

    public void addBitmap(@Nullable Bitmap bitmap, boolean dither, @BitmapMode int bitmapMode) {
        if (bitmap != null && !bitmap.isRecycled() && bitmap.getWidth() > 0 && bitmap.getHeight() > 0) {
            int dstBimapWidth = (int)Math.ceil((float)bitmap.getWidth() / 8.0f) * 8;
            int dstBitmapHeight = 8;
            if (bitmapMode == 32 || bitmapMode == 33) {
                dstBitmapHeight = 24;
            }
            if (bitmap.getHeight() > dstBitmapHeight) {
                bitmap = BitmapUtils.resizeBitmap(bitmap, dstBimapWidth, (int)Math.ceil((float)bitmap.getHeight() / 8.0f) * 8, false);
                List<Bitmap> bitmapList = BitmapUtils.cutBitmapByHeight(bitmap, dstBitmapHeight);
                for (Bitmap b : bitmapList) {
                    this.addBitmap(b, dither, bitmapMode);
                }
                return;
            }
            bitmap = BitmapUtils.resizeBitmap(bitmap, dstBimapWidth, dstBitmapHeight, false);
            if (dither) {
                bitmap = BitmapUtils.thresholdBitmap(bitmap, dither);
            }
            byte[] data = BitmapUtils.getDotMatrixOfBitmapForPrintVertical(bitmap, dither);
            this.addArrayToCommand(new byte[]{27, 42, (byte)bitmapMode, (byte)data.length, (byte)(data.length >> 8)});
            this.addArrayToCommand(data);
            this.printAndFeedUnits(dstBitmapHeight * 2 - 1);
        }
    }

    public void printAndFeedUnits(int units) {
        this.addArrayToCommand(new byte[]{27, 74, (byte)units});
    }

    public void drawImageDo(Bitmap bitmap, int mode) {
        int bmpWidth = bitmap.getWidth() % 8;
        int width1 = bmpWidth == 0 ? bitmap.getWidth() / 8 : bitmap.getWidth() / 8 + 1;
        int bmpHeight = bitmap.getHeight();
        byte[] printImage = BitmapUtils.getCompressedBinaryzationBytes(bitmap, 128, true);
        byte[] LData = new byte[printImage.length + 8];
        LData[0] = 27;
        LData[1] = 42;
        LData[2] = (byte)mode;
        LData[3] = 0;
        LData[4] = (byte)(width1 % 256);
        LData[5] = (byte)(width1 / 256);
        LData[6] = (byte)(bmpHeight % 256);
        LData[7] = (byte)(bmpHeight / 256);
        for (int i = 0; i < printImage.length; ++i) {
            LData[i + 8] = printImage[i];
        }
        for (int k = 0; k < LData.length; ++k) {
            this.Command.add(LData[k]);
        }
    }

    public static @interface BitmapMode {
    }
}

